k6 `v0.49.0` is here 🎉! This release:

- Adds a built-in [web dashboard](https://grafana.com/docs/k6/latest/results-output/web-dashboard/) that displays test results in real time.
- Introduces `clear` functionality to the browser module's `locator` classes.
- Merges the gRPC experimental module back into the gRPC core module.
- Enables the ability to get the selection from an element in `k6/html`.
- Collects internal modules and outputs used by a script.
- Prepares `k6/experimental/timers` for stabilization.


## Breaking changes

- [#3494](https://github.com/grafana/k6/pull/3494) stops updating `loadimpact/k6` docker image. If you still use it, please migrate to the [grafana/k6](https://hub.docker.com/r/grafana/k6) image.
- [browser#1111](https://github.com/grafana/xk6-browser/pull/1111) removes `timeout` option for `isVisible` and `isHidden` since the API no longer waits for the element to appear on the page.

## New features

### Web Dashboard

The new [web dashboard](https://grafana.com/docs/k6/latest/results-output/web-dashboard/) brings real-time visualization to load testing. This feature allows users to monitor test progress and analyze
results dynamically, enhancing the overall testing experience.

#### Real-time test results

Activate this feature using the environment variable `K6_WEB_DASHBOARD=true`. For this initial release, the dashboard is not enabled by default to allow users to opt into this new experience as it evolves.

```bash
K6_WEB_DASHBOARD=true k6 run script.js
```

Once enabled and the test script is running, navigate to [http://localhost:5665](http://localhost:5665) in your web browser to access the dashboard.

![k6 Web Dashboard Overview](https://github.com/grafana/xk6-dashboard/blob/master/screenshot/k6-dashboard-overview-light.png?raw=true)

#### Test report

The web dashboard also offers an HTML test report (see [an example](https://github.com/grafana/xk6-dashboard/blob/master/screenshot/k6-dashboard-html-report-screen-view.png?raw=true)) for detailed analysis, enabling easy sharing and downloading capabilities for
collaboration.

To access and download the report, click on the **Report** button in the dashboard's top right corner or use the `K6_WEB_DASHBOARD_EXPORT` environment variable.

```bash
K6_WEB_DASHBOARD=true K6_WEB_DASHBOARD_EXPORT=test-report.html k6 run script.js
```

### Add `clear` to the `locator` class [browser#1149](https://github.com/grafana/xk6-browser/pull/1149)

The new `clear` method on the `locator` class clears the text boxes and input fields. This is useful when navigating to a website where the text boxes and input fields already contain a value that needs to be cleared before filling it with a specific value.

<details>
<summary> Expand to see an example of the new functionality.</summary>

```javascript
import { check } from 'k6';
import { browser } from 'k6/experimental/browser';

export const options = {
  scenarios: {
    ui: {
      executor: 'shared-iterations',
      options: {
        browser: {
            type: 'chromium',
        },
      },
    },
  },
}

export default async function() {
  const context = browser.newContext();
  const page = context.newPage();

  await page.goto('https://test.k6.io/my_messages.php', { waitUntil: 'networkidle' });
  
  // To mimic an input field with existing text.
  page.locator('input[name="login"]').type('admin');

  check(page, {
    'not_empty': p => p.locator('input[name="login"]').inputValue() != '',
  });

  // Clear the text.
  page.locator('input[name="login"]').clear();

  check(page, {
    'empty': p => p.locator('input[name="login"]').inputValue() == '',
  });

  page.close();
}
```

</details>

### Add tracing to the browser module [browser#1100](https://github.com/grafana/xk6-browser/pull/1100)

The browser module now generates traces that provide a representation of its inner workings, such as API methods executed (for example `browser.newPage` and `page.goto`), page navigations, and [Web Vitals](https://grafana.com/docs/k6/latest/using-k6-browser/metrics/#googles-core-web-vitals) measurements.

Currently, the instrumented methods are a subset of all the methods exposed by the browser module API, but this will be extended in the future.

The traces generation for the browser module depends on the overall `k6` traces option introduced in [v0.48.0](https://github.com/grafana/k6/releases/tag/v0.48.0). Check out the [documentation](https://grafana.com/docs/k6/latest/using-k6/k6-options/reference/#traces-output) to learn more about it.

### gRPC streaming API becomes part of the k6 core [#3490](https://github.com/grafana/k6/pull/3490)

With this release, gRPC's streaming API becomes part of the core's `k6/net/grpc` module. The experimental `k6/experimental/grpc` has been back-merged into the core.

You can still use import `k6/experimental/grpc` for a couple of releases, but it's deprecated and will be removed in the future (planned in k6 version `v0.51.0`).

To migrate your scripts, replace `k6/experimental/grpc` with `k6/net/grpc` in your script imports, and the code should work as before.

### k6/html: Extract selection from element [#3519](https://github.com/grafana/k6/pull/3519)

[`k6/html`](https://grafana.com/docs/k6/latest/javascript-api/k6-html/) has been around for a while and allows you to search within an HTML document with a jQuery-like API called [Selection](https://grafana.com/docs/k6/latest/javascript-api/k6-html/selection/), and also has support for the more standard [Element](https://grafana.com/docs/k6/latest/javascript-api/k6-html/element/) that represents DOM element.

For a long time, you could get an Element from a Selection using the [`.get(index)`](https://grafana.com/docs/k6/latest/javascript-api/k6-html/selection/selection-get/), but you couldn't get back to a Selection from an Element.

This is not a common case, but one that requires quite a bit of code. For example, see the following jQuery snippet:

```javascript
let li = http.get("https://test.k6.io").html().find("li");
li.each(function(_, element) {
    // here element is an element not a selection
    // but what if for each li we want to select something more?
    // in jquery that will be:
   let container = $(element).closest('ul.header-icons');
    // but what should `$` do?
    // in a browser there is only 1 html document that you have access to
    // in k6 though you can be working with multiple ones, so `$` can't know which one it should
    // work against
});
```

In order to support the above example, you can use `selection`, without going to the element:

```javascript
let li = http.get("https://test.k6.io").html().find("li");
for (; li.size() > 0; li = li.next()) {
    let ul = li.closest('ul.header-icons'); // li here is still a selection and we iterate over it.
}
```

This is not always possible though, and arguably isn't what most users will naturally do.

Because of this, we have now added a new [`.selection()`](https://grafana.com/docs/k6/latest/javascript-api/k6-html/element/element-selection/) which returns a selection for its element.


```javascript
   let li = http.get("https://test.k6.io").html().find("li");
   li.each(function(_, element) {
      let container = element.selection().closest('ul.header-icons');
        // .. more code
   });
```

Thanks to @Azhovan! :bow: :tada:

### Collect usage data on imported internal modules and outputs [#3525](https://github.com/grafana/k6/pull/3525)

k6 now collects usage data of the modules and outputs that are being used when the [usage report](https://grafana.com/docs/k6/latest/misc/usage-collection) is enabled. The data collection is only related to the built-in k6 modules and outputs. Private, custom modules and extensions [are never collected](https://github.com/grafana/k6/blob/f35e67902605877ebf2c5e9c8673cd7faf4cdc1e/cmd/report.go#L33-L57). The usage report is enabled by default in k6, but it is possible to opt-out using the [no-usage-report](https://grafana.com/docs/k6/latest/using-k6/k6-options/reference/#no-usage-report) option.

We always want to improve the product, but at the same time, we need to pay attention to where we allocate our resources. Having data of what are the most used modules and outputs gives us better confidence to make decisions because we are supported by data.
The data can let us know what percentage of our users will benefit from the introduction of a new feature and also, how many of them would be impacted in case of a breaking change.

## UX improvements and enhancements

- [#3529](https://github.com/grafana/k6/pull/3529) enables the k6 cloud traces output by default.
- [#3440](https://github.com/grafana/k6/pull/3440) adds a fallback for using built-in certificates if the OS provides none. Thanks to `@mem` for working on it!
- [browser#1104](https://github.com/grafana/xk6-browser/pull/1104) adds support for browser module traces metadata. Users can define *key-value* metadata that will be included as attributes in every generated span.
- [browser#1135](https://github.com/grafana/xk6-browser/pull/1135) improves the array output from `console` in the k6 logs.
- [browser#1137](https://github.com/grafana/xk6-browser/pull/1137), [browser#1145](https://github.com/grafana/xk6-browser/pull/1145) improves the error messages displayed when Chrome or Chromium isn't found.
- [#3543](https://github.com/grafana/k6/pull/3543) replaces documentation URLs to `grafana.com/docs/k6/latest/`.

## Bug fixes

- [#3485](https://github.com/grafana/k6/pull/3485) fixes the REST API always logging a 200 status code response, which was found as part of fixing lint issues in the code.
- [browser#1129](https://github.com/grafana/xk6-browser/pull/1129) mitigates the risk of panics when the website under test uses the `console`.
- [browser#1133](https://github.com/grafana/xk6-browser/pull/1133) fixes `BigInt` parsing.
- [browser#1108](https://github.com/grafana/xk6-browser/pull/1108), [browser#1110](https://github.com/grafana/xk6-browser/pull/1110) fixes `isVisible` and `isHidden` so that it doesn't wait for an element to match with the given `selector`, allowing it to continue on with the test script when elements are not on the page.
- [browser#1121](https://github.com/grafana/xk6-browser/pull/1121) fixes `dblClick` so that it works with `onDblClick` and performs two clicks on the specified element.
- [browser#1152](https://github.com/grafana/xk6-browser/pull/1152) fixes a nil pointer dereference when navigating around on SPA websites.

## Maintenance and internal improvements

- [#3204](https://github.com/grafana/k6/pull/3204) internal refactor to make future distributed execution work easier. With a small fix to tests in [#3531](https://github.com/grafana/k6/pull/3531). Thanks to @na-- :tada:.
- Lint fixes throughout the k6 code base [#3460](https://github.com/grafana/k6/pull/3460), [#3462](https://github.com/grafana/k6/pull/3462), [#3463](https://github.com/grafana/k6/pull/3463), [#3478](https://github.com/grafana/k6/pull/3478), [#3479](https://github.com/grafana/k6/pull/3479), [#3480](https://github.com/grafana/k6/pull/3480), [#3481](https://github.com/grafana/k6/pull/3481), [#3482](https://github.com/grafana/k6/pull/3482), [#3483](https://github.com/grafana/k6/pull/3483), [#3484](https://github.com/grafana/k6/pull/3484), [#3485](https://github.com/grafana/k6/pull/3485), [#3495](https://github.com/grafana/k6/pull/3495).
- [#3473](https://github.com/grafana/k6/pull/3473) refinements to the release process.
- Dependency updates across k6 [#3500](https://github.com/grafana/k6/pull/3500), [#3501](https://github.com/grafana/k6/pull/3501), [#3502](https://github.com/grafana/k6/pull/3502), [#3503](https://github.com/grafana/k6/pull/3503), [#3509](https://github.com/grafana/k6/pull/3509), [#3513](https://github.com/grafana/k6/pull/3513), [#3537](https://github.com/grafana/k6/pull/3537), [#3539](https://github.com/grafana/k6/pull/3539), [#3540](https://github.com/grafana/k6/pull/3540).
- [#3489](https://github.com/grafana/k6/pull/3489) migrates pull-requests assignment to `CODEOWNERS` from GitHub Action.
- [#3496](https://github.com/grafana/k6/pull/3496) checks for security issues with a scheduled trivy scan.
- [#3517](https://github.com/grafana/k6/pull/3517) adds unit tests to the cloadapi package. This is the first contribution by external contributor @nilskch. Thanks for this @nilskch :bow:.
- [#3520](https://github.com/grafana/k6/pull/3520) stops using deprecated by golang net.Dialer.DualStack option.
- [#3526](https://github.com/grafana/k6/pull/3526) refactors to JavaScript package test around `open` and `require` and their handling of paths.
- [#3527](https://github.com/grafana/k6/pull/3527) generates test certificates for more tests during the test. This, among other things, fixes macOS tests.
- [#3528](https://github.com/grafana/k6/pull/3528) enables macOS tests in GitHub Actions.
- [browser#1134](https://github.com/grafana/xk6-browser/pull/1134) adds a new error type when parsing objects.
- [browser#1107](https://github.com/grafana/xk6-browser/pull/1107), [browser#1109](https://github.com/grafana/xk6-browser/pull/1109) refactor internals.


##  Roadmap

As mentioned earlier, there's work in progress to make xk6-timers stable as part of the next release. You can find more information on issue [#3297](https://github.com/grafana/k6/issues/3297).
